/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rbf.RbfHandleResponse;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.util.Trace;

class QueryReply
implements RbfReply {
    private static final String TRACE_MASKT = "XRBFQMRT";
    private static final String TRACE_MASKF = "XRBFQMRF";
    private static final String TRACE_MASKD = "XRBFQMRD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-QueryRpy");
    private static final long serialVersionUID = -3128239139247611716L;
    private RbfRequestId requestId;
    private int status;
    private byte[] responseEncoding;
    static final int STATUS_PREPARING = 0;
    static final int STATUS_ABORTING = 2;
    static final int STATUS_HANDLING = 4;
    static final int STATUS_CANCELING = 8;
    static final int STATUS_COMPLETE = 12;
    static final int STATUS_NOT_FOUND = 16;

    QueryReply(RbfRequestId requestId, int status) {
        if (requestId == null) {
            throw new IllegalArgumentException("Null request identifier specified");
        }
        if (!this.isValidStatus(status)) {
            throw new IllegalArgumentException("Invalid status specified");
        }
        this.requestId = requestId;
        this.status = status;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    QueryReply(RbfRequestId requestId, int status, RbfHandleResponse handleResponse) throws PersistenceException {
        if (requestId == null) {
            throw new IllegalArgumentException("Null request identifier specified");
        }
        if (!this.isValidStatus(status)) {
            throw new IllegalArgumentException("Invalid status specified");
        }
        this.requestId = requestId;
        this.status = status;
        try {
            PersistenceManager pm = PersistenceManager.getPersistenceManager();
            this.responseEncoding = PersistenceManager.encode(handleResponse);
        }
        catch (PersistenceException pe) {
            Trace.trace(TRACE_MASKF, pe.getClass().getName() + " encoding " + handleResponse.getClass().getName() + " " + requestId);
            Trace.trace(TRACE_MASKF, pe);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1056, pe);
            fl.add(RbfUtils.getLoggingInfo());
            fl.log();
            throw pe;
        }
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    boolean isValidStatus(int status) {
        switch (status) {
            case 0: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
            case 12: {
                return true;
            }
            case 16: {
                return true;
            }
        }
        return false;
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    int getStatus() {
        return this.status;
    }

    byte[] getResponseEncoding() {
        return this.responseEncoding;
    }

    public void process(MachineId sender2, int protocol) {
        Trace.trace(TRACE_MASKT, "-> process()");
        Trace.trace(TRACE_MASKT, "<- process()");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[QueryReply: reqId=" + this.requestId + ", status=" + this.status);
        if (this.responseEncoding != null) {
            sb.append(", responseEncoding=yes");
        } else {
            sb.append(", responseEncoding=null");
        }
        sb.append("]");
        return sb.toString();
    }
}

